<?php
session_start();
require_once 'db_connect.php';

// Placeholder game page - to be expanded with actual games
$game_id = $_SESSION['razrox_game_id'] ?? null;
$player_id = $_SESSION['razrox_player_id'] ?? null;
$is_host = $_SESSION['razrox_is_host'] ?? false;

if (!$game_id || !$player_id) {
    header('Location: index.php');
    exit;
}

// Get game and player info
$stmt = mysqli_prepare($db_handle, "
    SELECT g.*, p.player_name
    FROM razrox_games g
    JOIN razrox_players p ON p.game_id = g.id
    WHERE g.id = ? AND p.id = ?
");
mysqli_stmt_bind_param($stmt, 'ii', $game_id, $player_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$data = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

if (!$data) {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RazRox - Game</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .game-container {
            background: white;
            border-radius: 20px;
            padding: 3rem;
            text-align: center;
            max-width: 600px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        
        h1 {
            color: #667eea;
            margin-bottom: 1rem;
        }
        
        .message {
            color: #666;
            font-size: 1.2rem;
            margin-bottom: 2rem;
        }
        
        .player-info {
            background: #f5f7fa;
            padding: 1rem;
            border-radius: 10px;
            margin-bottom: 2rem;
        }
        
        .btn {
            display: inline-block;
            padding: 1rem 2rem;
            font-size: 1.1rem;
            font-weight: 700;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            text-decoration: none;
            margin: 0.5rem;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-secondary {
            background: #eee;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="game-container">
        <h1>🎮 Game Started!</h1>
        
        <p class="message">
            The game engine is ready! This is where the actual party games will be implemented.
        </p>
        
        <div class="player-info">
            <p><strong>Playing as:</strong> <?= htmlspecialchars($data['player_name']) ?></p>
            <p><strong>Game Code:</strong> <?= htmlspecialchars($data['game_code']) ?></p>
            <?php if ($is_host): ?>
                <p><strong>Role:</strong> 👑 Host</p>
            <?php endif; ?>
        </div>
        
        <p style="color: #888; margin-bottom: 2rem;">
            Coming soon: Trivia, Drawing Games, Word Games, and more!
        </p>
        
        <a href="leave_game.php" class="btn btn-secondary">Leave Game</a>
    </div>
</body>
</html>
