<?php
session_start();
require_once 'db_connect.php';

if (!$db_handle) {
    exit;
}

$player_id = $_SESSION['razrox_player_id'] ?? null;
$session_token = $_SESSION['razrox_session_token'] ?? null;

if ($player_id && $session_token) {
    // Verify and update last activity
    $stmt = mysqli_prepare($db_handle, "
        UPDATE razrox_players 
        SET last_activity = NOW(), is_connected = 1 
        WHERE id = ? AND session_token = ?
    ");
    mysqli_stmt_bind_param($stmt, 'is', $player_id, $session_token);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

echo 'ok';
