<?php
session_start();
require_once 'db_connect.php';

if (!$db_handle) {
    die('Database connection failed');
}

// Get form data
$game_code = strtoupper(trim($_POST['game_code'] ?? ''));
$player_name = trim($_POST['player_name'] ?? '');

if (empty($game_code) || empty($player_name)) {
    header('Location: index.php?error=missing_fields');
    exit;
}

// Find the game
$stmt = mysqli_prepare($db_handle, "
    SELECT id, game_status, max_players 
    FROM razrox_games 
    WHERE game_code = ? AND is_active = 1
");
mysqli_stmt_bind_param($stmt, 's', $game_code);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$game = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

if (!$game) {
    header('Location: index.php?error=game_not_found');
    exit;
}

if ($game['game_status'] !== 'lobby') {
    header('Location: index.php?error=game_in_progress');
    exit;
}

// Check current player count
$stmt = mysqli_prepare($db_handle, "SELECT COUNT(*) as count FROM razrox_players WHERE game_id = ? AND is_connected = 1");
mysqli_stmt_bind_param($stmt, 'i', $game['id']);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$count_row = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

if ($count_row['count'] >= $game['max_players']) {
    header('Location: index.php?error=game_full');
    exit;
}

// Check if name already taken in this game
$stmt = mysqli_prepare($db_handle, "SELECT id FROM razrox_players WHERE game_id = ? AND player_name = ? AND is_connected = 1");
mysqli_stmt_bind_param($stmt, 'is', $game['id'], $player_name);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
if (mysqli_num_rows($result) > 0) {
    header('Location: index.php?error=name_taken');
    exit;
}
mysqli_stmt_close($stmt);

// Generate session token
$session_token = bin2hex(random_bytes(32));

// Create player
$stmt = mysqli_prepare($db_handle, "
    INSERT INTO razrox_players (game_id, player_name, is_host, session_token) 
    VALUES (?, ?, 0, ?)
");
mysqli_stmt_bind_param($stmt, 'iss', $game['id'], $player_name, $session_token);

if (mysqli_stmt_execute($stmt)) {
    $player_id = mysqli_insert_id($db_handle);
    mysqli_stmt_close($stmt);
    
    // Store session info
    $_SESSION['razrox_game_id'] = $game['id'];
    $_SESSION['razrox_player_id'] = $player_id;
    $_SESSION['razrox_session_token'] = $session_token;
    $_SESSION['razrox_is_host'] = false;
    
    // Redirect to lobby
    header('Location: lobby.php?code=' . $game_code);
    exit;
} else {
    mysqli_stmt_close($stmt);
    header('Location: index.php?error=join_failed');
    exit;
}
