-- RazRox Party Games Database Setup
-- Run this SQL on your MariaDB server

-- Games table - stores active and past game sessions
CREATE TABLE IF NOT EXISTS razrox_games (
    id INT AUTO_INCREMENT PRIMARY KEY,
    game_code VARCHAR(6) NOT NULL UNIQUE,
    host_player_id INT DEFAULT NULL,
    is_active TINYINT(1) DEFAULT 1,
    game_status ENUM('lobby', 'playing', 'finished') DEFAULT 'lobby',
    max_players INT DEFAULT 8,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_game_code (game_code),
    INDEX idx_is_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Players table - stores players in each game
CREATE TABLE IF NOT EXISTS razrox_players (
    id INT AUTO_INCREMENT PRIMARY KEY,
    game_id INT NOT NULL,
    player_name VARCHAR(50) NOT NULL,
    is_host TINYINT(1) DEFAULT 0,
    is_connected TINYINT(1) DEFAULT 1,
    session_token VARCHAR(64) NOT NULL,
    score INT DEFAULT 0,
    joined_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_activity TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (game_id) REFERENCES razrox_games(id) ON DELETE CASCADE,
    INDEX idx_game_id (game_id),
    INDEX idx_session_token (session_token)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Update games table to reference host player after players table exists
ALTER TABLE razrox_games 
ADD CONSTRAINT fk_host_player 
FOREIGN KEY (host_player_id) REFERENCES razrox_players(id) ON DELETE SET NULL;
