<?php
session_start();
require_once 'db_connect.php';

header('Content-Type: application/json');

if (!$db_handle) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

$game_id = intval($_GET['game_id'] ?? 0);

if ($game_id <= 0) {
    echo json_encode(['error' => 'Invalid game ID']);
    exit;
}

// Get game info
$stmt = mysqli_prepare($db_handle, "SELECT game_status FROM razrox_games WHERE id = ? AND is_active = 1");
mysqli_stmt_bind_param($stmt, 'i', $game_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$game = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

if (!$game) {
    echo json_encode(['error' => 'Game not found']);
    exit;
}

// Mark inactive players (no activity in last 30 seconds)
$stmt = mysqli_prepare($db_handle, "
    UPDATE razrox_players 
    SET is_connected = 0 
    WHERE game_id = ? AND last_activity < DATE_SUB(NOW(), INTERVAL 30 SECOND)
");
mysqli_stmt_bind_param($stmt, 'i', $game_id);
mysqli_stmt_execute($stmt);
mysqli_stmt_close($stmt);

// Get all connected players
$stmt = mysqli_prepare($db_handle, "
    SELECT id, player_name, is_host, score
    FROM razrox_players 
    WHERE game_id = ? AND is_connected = 1
    ORDER BY is_host DESC, joined_at ASC
");
mysqli_stmt_bind_param($stmt, 'i', $game_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$players = mysqli_fetch_all($result, MYSQLI_ASSOC);
mysqli_stmt_close($stmt);

echo json_encode([
    'players' => $players,
    'game_status' => $game['game_status']
]);
