<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RazRox Party Games</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            text-align: center;
            max-width: 500px;
            width: 100%;
        }
        
        .logo {
            font-size: 4rem;
            font-weight: 900;
            color: white;
            text-shadow: 4px 4px 0 rgba(0,0,0,0.2);
            margin-bottom: 0.5rem;
            letter-spacing: -2px;
        }
        
        .tagline {
            color: rgba(255,255,255,0.9);
            font-size: 1.2rem;
            margin-bottom: 3rem;
        }
        
        .menu-card {
            background: white;
            border-radius: 20px;
            padding: 2.5rem;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        
        .btn {
            display: block;
            width: 100%;
            padding: 1.2rem 2rem;
            font-size: 1.3rem;
            font-weight: 700;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.2s ease;
            margin-bottom: 1rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn:last-child {
            margin-bottom: 0;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.5);
        }
        
        .btn-secondary {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
        }
        
        .btn-secondary:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(245, 87, 108, 0.5);
        }
        
        .join-form {
            display: none;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 2px solid #eee;
        }
        
        .join-form.active {
            display: block;
        }
        
        .form-group {
            margin-bottom: 1rem;
        }
        
        .form-group label {
            display: block;
            text-align: left;
            font-weight: 600;
            color: #333;
            margin-bottom: 0.5rem;
        }
        
        .form-group input {
            width: 100%;
            padding: 1rem;
            font-size: 1.5rem;
            text-align: center;
            border: 3px solid #ddd;
            border-radius: 10px;
            text-transform: uppercase;
            letter-spacing: 8px;
            font-weight: bold;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .form-group input.name-input {
            text-transform: none;
            letter-spacing: normal;
            font-size: 1.2rem;
        }
        
        .error-message {
            background: #fee;
            color: #c00;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            display: none;
        }
        
        .error-message.show {
            display: block;
        }
        
        .back-btn {
            background: #eee;
            color: #666;
            font-size: 1rem;
            padding: 0.8rem 1.5rem;
        }
        
        .back-btn:hover {
            background: #ddd;
            transform: none;
            box-shadow: none;
        }
        
        footer {
            margin-top: 2rem;
            color: rgba(255,255,255,0.7);
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="logo">RazRox</h1>
        <p class="tagline">Party Games for Everyone!</p>
        
        <div class="menu-card">
            <div id="main-menu">
                <button class="btn btn-primary" onclick="showJoinForm()">Join Game</button>
                <button class="btn btn-secondary" onclick="showStartForm()">Start New Game</button>
            </div>
            
            <div id="join-form" class="join-form">
                <div id="join-error" class="error-message"></div>
                <form action="join_game.php" method="POST" onsubmit="return validateJoin()">
                    <div class="form-group">
                        <label for="game_code">Game Code</label>
                        <input type="text" id="game_code" name="game_code" maxlength="6" placeholder="ABCD12" required>
                    </div>
                    <div class="form-group">
                        <label for="join_player_name">Your Name</label>
                        <input type="text" id="join_player_name" name="player_name" class="name-input" maxlength="20" placeholder="Enter your name" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Join!</button>
                    <button type="button" class="btn back-btn" onclick="showMainMenu()">Back</button>
                </form>
            </div>
            
            <div id="start-form" class="join-form">
                <div id="start-error" class="error-message"></div>
                <form action="create_game.php" method="POST" onsubmit="return validateStart()">
                    <div class="form-group">
                        <label for="host_name">Your Name (Host)</label>
                        <input type="text" id="host_name" name="player_name" class="name-input" maxlength="20" placeholder="Enter your name" required>
                    </div>
                    <button type="submit" class="btn btn-secondary">Create Game!</button>
                    <button type="button" class="btn back-btn" onclick="showMainMenu()">Back</button>
                </form>
            </div>
        </div>
    </div>
    
    <footer>
        &copy; <?= date('Y') ?> RazRox Party Games
    </footer>
    
    <script>
        function showMainMenu() {
            document.getElementById('main-menu').style.display = 'block';
            document.getElementById('join-form').classList.remove('active');
            document.getElementById('start-form').classList.remove('active');
        }
        
        function showJoinForm() {
            document.getElementById('main-menu').style.display = 'none';
            document.getElementById('join-form').classList.add('active');
            document.getElementById('start-form').classList.remove('active');
            document.getElementById('game_code').focus();
        }
        
        function showStartForm() {
            document.getElementById('main-menu').style.display = 'none';
            document.getElementById('start-form').classList.add('active');
            document.getElementById('join-form').classList.remove('active');
            document.getElementById('host_name').focus();
        }
        
        function validateJoin() {
            const code = document.getElementById('game_code').value.trim();
            const name = document.getElementById('join_player_name').value.trim();
            const errorDiv = document.getElementById('join-error');
            
            if (code.length < 4) {
                errorDiv.textContent = 'Please enter a valid game code.';
                errorDiv.classList.add('show');
                return false;
            }
            
            if (name.length < 1) {
                errorDiv.textContent = 'Please enter your name.';
                errorDiv.classList.add('show');
                return false;
            }
            
            errorDiv.classList.remove('show');
            return true;
        }
        
        function validateStart() {
            const name = document.getElementById('host_name').value.trim();
            const errorDiv = document.getElementById('start-error');
            
            if (name.length < 1) {
                errorDiv.textContent = 'Please enter your name.';
                errorDiv.classList.add('show');
                return false;
            }
            
            errorDiv.classList.remove('show');
            return true;
        }
        
        // Auto-uppercase game code
        document.getElementById('game_code').addEventListener('input', function() {
            this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
        });
        
        // Check if coming from QR code with pre-filled code
        const urlParams = new URLSearchParams(window.location.search);
        const prefilledCode = urlParams.get('code');
        if (prefilledCode) {
            document.getElementById('game_code').value = prefilledCode.toUpperCase();
            showJoinForm();
            // Focus on name field since code is already filled
            document.getElementById('join_player_name').focus();
        }
    </script>
</body>
</html>
