<?php
session_start();
require_once 'db_connect.php';

if ($db_handle) {
    $player_id = $_SESSION['razrox_player_id'] ?? null;
    $session_token = $_SESSION['razrox_session_token'] ?? null;
    $game_id = $_SESSION['razrox_game_id'] ?? null;
    $is_host = $_SESSION['razrox_is_host'] ?? false;
    
    if ($player_id && $session_token) {
        // Mark player as disconnected
        $stmt = mysqli_prepare($db_handle, "
            UPDATE razrox_players 
            SET is_connected = 0 
            WHERE id = ? AND session_token = ?
        ");
        mysqli_stmt_bind_param($stmt, 'is', $player_id, $session_token);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        
        // If host leaves during lobby, end the game
        if ($is_host && $game_id) {
            $stmt = mysqli_prepare($db_handle, "
                UPDATE razrox_games 
                SET is_active = 0 
                WHERE id = ? AND game_status = 'lobby'
            ");
            mysqli_stmt_bind_param($stmt, 'i', $game_id);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);
        }
    }
}

// Clear session
unset($_SESSION['razrox_game_id']);
unset($_SESSION['razrox_player_id']);
unset($_SESSION['razrox_session_token']);
unset($_SESSION['razrox_is_host']);

header('Location: index.php');
exit;
