<?php
session_start();
require_once 'db_connect.php';

header('Content-Type: application/json');

if (!$db_handle) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

// Verify session
$game_id = $_SESSION['razrox_game_id'] ?? null;
$player_id = $_SESSION['razrox_player_id'] ?? null;
$is_host = $_SESSION['razrox_is_host'] ?? false;

if (!$game_id || !$player_id || !$is_host) {
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Verify player is actually the host
$stmt = mysqli_prepare($db_handle, "
    SELECT g.id FROM razrox_games g
    JOIN razrox_players p ON p.game_id = g.id
    WHERE g.id = ? AND p.id = ? AND p.is_host = 1 AND g.is_active = 1 AND g.game_status = 'lobby'
");
mysqli_stmt_bind_param($stmt, 'ii', $game_id, $player_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$game = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

if (!$game) {
    echo json_encode(['error' => 'Cannot start game']);
    exit;
}

// Check minimum players
$stmt = mysqli_prepare($db_handle, "SELECT COUNT(*) as count FROM razrox_players WHERE game_id = ? AND is_connected = 1");
mysqli_stmt_bind_param($stmt, 'i', $game_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$count = mysqli_fetch_assoc($result)['count'];
mysqli_stmt_close($stmt);

if ($count < 2) {
    echo json_encode(['error' => 'Need at least 2 players to start']);
    exit;
}

// Update game status to playing
$stmt = mysqli_prepare($db_handle, "UPDATE razrox_games SET game_status = 'playing' WHERE id = ?");
mysqli_stmt_bind_param($stmt, 'i', $game_id);
$success = mysqli_stmt_execute($stmt);
mysqli_stmt_close($stmt);

if ($success) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['error' => 'Failed to start game']);
}
