-- RazRox Trivia Game Tables
-- Run this SQL after setup_tables.sql

-- Trivia rounds - tracks each round of questions in a game
CREATE TABLE IF NOT EXISTS razrox_trivia_rounds (
    id INT AUTO_INCREMENT PRIMARY KEY,
    game_id INT NOT NULL,
    question_id INT NOT NULL,
    round_number INT NOT NULL,
    started_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ended_at TIMESTAMP NULL,
    is_active TINYINT(1) DEFAULT 1,
    FOREIGN KEY (game_id) REFERENCES razrox_games(id) ON DELETE CASCADE,
    FOREIGN KEY (question_id) REFERENCES Trivia(id),
    UNIQUE KEY unique_game_question (game_id, question_id),
    INDEX idx_game_round (game_id, round_number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Player answers - tracks each player's answer per round
CREATE TABLE IF NOT EXISTS razrox_trivia_answers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    round_id INT NOT NULL,
    player_id INT NOT NULL,
    answer VARCHAR(255) NOT NULL,
    is_correct TINYINT(1) DEFAULT 0,
    time_remaining_ms INT DEFAULT 0,
    points_awarded INT DEFAULT 0,
    answered_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (round_id) REFERENCES razrox_trivia_rounds(id) ON DELETE CASCADE,
    FOREIGN KEY (player_id) REFERENCES razrox_players(id) ON DELETE CASCADE,
    UNIQUE KEY unique_player_round (round_id, player_id),
    INDEX idx_round_id (round_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add game_type and current_round to games table
ALTER TABLE razrox_games 
ADD COLUMN game_type VARCHAR(50) DEFAULT 'trivia' AFTER game_status,
ADD COLUMN current_round INT DEFAULT 0 AFTER game_type,
ADD COLUMN total_rounds INT DEFAULT 10 AFTER current_round;
