# Hackbox Production - cPanel Deployment Guide

A production-ready Jackbox-style party game platform optimized for cPanel deployment.

## Quick Setup for cPanel

### Step 1: Prepare the React Build

Before uploading to cPanel, you need to build the React frontend. Run these commands locally:

```bash
# Navigate to the original hackbox-demo folder
cd hackbox-demo

# Install dependencies (if not already done)
npm install

# Build the React app
npm run build

# Copy the build folder to hackbox-production
cp -r build ../hackbox-production/
```

### Step 2: Upload to cPanel

1. Upload the entire `hackbox-production` folder to your cPanel account
   - Recommended location: `/home/yourusername/hackbox-production/`
   - Or inside public_html if it's your main site

### Step 3: Configure Node.js Application in cPanel

Go to **cPanel → Setup Node.js App** and click "Create Application":

| Setting | Value |
|---------|-------|
| **Node.js version** | 18.x or 16.x (LTS recommended) |
| **Application mode** | Production |
| **Application root** | `hackbox-production` (or full path) |
| **Application URL** | Your domain/subdomain |
| **Application startup file** | `server.js` |

### Step 4: Install Dependencies

After creating the application, click **"Run NPM Install"** in cPanel, or SSH in and run:

```bash
cd /home/yourusername/hackbox-production
source /home/yourusername/nodevenv/hackbox-production/18/bin/activate
npm install
```

### Step 5: Start the Application

Click **"Start App"** in cPanel's Node.js interface.

---

## Environment Variables

cPanel automatically sets the `PORT` environment variable. The app will use whatever port cPanel assigns.

If you need to set custom environment variables:
1. Go to the Node.js app settings in cPanel
2. Add environment variables in the interface

---

## Project Structure

```
hackbox-production/
├── server.js              # Main entry point (startup file)
├── package.json           # Dependencies
├── .htaccess             # Apache configuration for Node.js
├── build/                 # React production build (copy from hackbox-demo)
│   ├── index.html
│   ├── static/
│   └── ...
└── lib/
    ├── hackbox-server.js  # Socket.io server setup
    ├── hackbox-client.js  # Client library (for reference)
    ├── attachListeners.js # Game event handlers
    ├── gameReference.js   # Game configurations
    ├── utils.js           # Helper functions
    └── objects/
        ├── index.js
        ├── playerManager.js
        └── roomManager.js
```

---

## Updating the Client Code

If you modify the React frontend in `hackbox-demo`:

1. Rebuild locally: `cd hackbox-demo && npm run build`
2. Delete the old `build` folder in `hackbox-production`
3. Copy the new build: `cp -r hackbox-demo/build hackbox-production/`
4. Upload to cPanel
5. Restart the Node.js application in cPanel

---

## Important Notes for cPanel

### WebSocket Support
- Most cPanel hosts support WebSockets through Passenger
- The `.htaccess` file includes WebSocket proxy rules
- If WebSockets don't work, contact your host about enabling WebSocket support

### Application Won't Start?
1. Check the error logs in cPanel (Errors section or in `~/logs/`)
2. Make sure Node.js version is compatible (14+)
3. Ensure all dependencies installed correctly
4. Verify the `build` folder exists with the React app

### Performance Tips
- The app uses in-memory storage for rooms/players
- Rooms are automatically cleaned up after inactivity
- For high traffic, consider adding Redis for session storage

---

## Local Testing

To test locally before deploying:

```bash
cd hackbox-production
npm install
node server.js
```

Then open http://localhost:8080 in your browser.

---

## Games Included

- **Quiplash** 💬 - Write funny answers to prompts, vote on favorites
- **Trivia** 🧠 - Answer questions quickly to earn points
- **Drawful** 🎨 - Draw prompts, guess what others drew

---

## Troubleshooting

**"Cannot find module" errors:**
- Run `npm install` in the application directory
- Make sure you're using the correct Node.js environment

**Socket.io connection issues:**
- Check if WebSockets are enabled on your host
- Try the polling fallback (Socket.io handles this automatically)

**React app not loading:**
- Ensure the `build` folder exists
- Check that `build/index.html` is present
- Verify static files are being served correctly

**App crashes on start:**
- Check cPanel error logs
- Verify `server.js` is set as the startup file
- Ensure port isn't hardcoded (use `process.env.PORT`)
