module.exports = {
  gameTypes: ['quiplash', 'trivia', 'drawful'],
  
  quiplash: {
    name: 'Quiplash',
    description: 'Answer prompts with funny responses, then vote on the best one!',
    minPlayers: 3,
    maxPlayers: 8,
    rounds: 3,
    promptTime: 60000,     // 60 seconds to answer
    voteTime: 30000,       // 30 seconds to vote
    resultsTime: 10000,    // 10 seconds to show results
    icon: '💬',
    color: '#FF6B6B'
  },
  
  trivia: {
    name: 'Trivia',
    description: 'Answer trivia questions quickly to score points!',
    minPlayers: 1,
    maxPlayers: 8,
    rounds: 3,
    questionsPerRound: 5,
    questionTime: 15000,   // 15 seconds per question
    resultsTime: 5000,     // 5 seconds to show results
    icon: '🧠',
    color: '#4ECDC4'
  },
  
  drawful: {
    name: 'Drawful',
    description: 'Draw a prompt, then try to guess what others drew!',
    minPlayers: 3,
    maxPlayers: 8,
    rounds: 2,
    drawTime: 90000,       // 90 seconds to draw
    guessTime: 45000,      // 45 seconds to write fake answers
    voteTime: 30000,       // 30 seconds to vote
    resultsTime: 10000,    // 10 seconds to show results
    icon: '🎨',
    color: '#45B7D1'
  }
};
