class PlayerManager {
  constructor () {
    this.players = [];
  }

  addPlayer ({ id, roomId, socketId, name, color }) {
    const player = {
      id,
      roomId,
      socketId,
      name,
      color: color || '#4ECDC4',
      isReady: false,
      score: 0,
      hasAnswered: false,
      hasVoted: false,
      hasDrawn: false
    };
    this.players.push(player);
    return player;
  }

  removePlayer (id) {
    const removedPlayer = this.players.find(player => player.id === id);

    if (removedPlayer) {
      this.players = this.players.filter(player => player.id !== id);
    }

    return removedPlayer;
  }

  getPlayer (id) {
    return this.players.find(player => player.id === id);
  }

  getPlayerBySocketId (socketId) {
    return this.players.find(player => player.socketId === socketId);
  }

  updatePlayer (id, updates) {
    const player = this.getPlayer(id);
    if (player) {
      Object.assign(player, updates);
    }
    return player;
  }

  resetPlayerState (id) {
    const player = this.getPlayer(id);
    if (player) {
      player.hasAnswered = false;
      player.hasVoted = false;
      player.hasDrawn = false;
      player.isReady = false;
    }
    return player;
  }
}

module.exports = PlayerManager;
