const generateId = () => {
  return Math.random()
    .toString(36)
    .substr(2, 5)
    .toUpperCase();
};

const shuffleArray = (array) => {
  const shuffled = [...array];
  for (let i = shuffled.length - 1; i > 0; i--) {
    const j = Math.floor(Math.random() * (i + 1));
    [shuffled[i], shuffled[j]] = [shuffled[j], shuffled[i]];
  }
  return shuffled;
};

const getQuiplashPrompts = (playerCount) => {
  const allPrompts = [
    "The worst thing to say on a first date",
    "Something you should never Google",
    "A terrible name for a band",
    "The worst superhero power",
    "Something you'd find in a wizard's junk drawer",
    "A bad reason to call 911",
    "The worst flavor of ice cream",
    "Something you shouldn't yell at a funeral",
    "A rejected McDonald's menu item",
    "The worst thing to find in your soup",
    "A terrible fortune cookie message",
    "The worst name for a pet",
    "Something you shouldn't say to your boss",
    "A bad tattoo idea",
    "The worst thing to whisper to someone",
    "A rejected Pixar movie title",
    "Something that would ruin a wedding",
    "The worst pickup line ever",
    "A bad slogan for a hospital",
    "Something you shouldn't put on a resume",
    "The worst thing to say during a job interview",
    "A terrible name for a breakfast cereal",
    "Something aliens would find weird about humans",
    "The worst advice to give a child",
    "A bad name for a dating app",
    "Something you shouldn't sell on eBay",
    "The worst excuse for being late",
    "A terrible theme for a birthday party",
    "Something that would make a bad Olympic sport",
    "The worst thing to say to a cop"
  ];
  
  // Generate enough prompts for the round (each prompt needs 2 players)
  const promptCount = Math.max(playerCount, 3);
  const shuffled = shuffleArray(allPrompts);
  
  return shuffled.slice(0, promptCount).map((text, index) => ({
    id: generateId(),
    text,
    index
  }));
};

const getTriviaQuestions = (count) => {
  const allQuestions = [
    {
      question: "What is the capital of Australia?",
      options: ["Sydney", "Melbourne", "Canberra", "Perth"],
      correctIndex: 2
    },
    {
      question: "Which planet is known as the Red Planet?",
      options: ["Venus", "Mars", "Jupiter", "Saturn"],
      correctIndex: 1
    },
    {
      question: "What year did the Titanic sink?",
      options: ["1905", "1912", "1920", "1898"],
      correctIndex: 1
    },
    {
      question: "Who painted the Mona Lisa?",
      options: ["Michelangelo", "Raphael", "Leonardo da Vinci", "Donatello"],
      correctIndex: 2
    },
    {
      question: "What is the largest mammal in the world?",
      options: ["African Elephant", "Blue Whale", "Giraffe", "Polar Bear"],
      correctIndex: 1
    },
    {
      question: "How many continents are there?",
      options: ["5", "6", "7", "8"],
      correctIndex: 2
    },
    {
      question: "What is the chemical symbol for gold?",
      options: ["Go", "Gd", "Au", "Ag"],
      correctIndex: 2
    },
    {
      question: "Which country invented pizza?",
      options: ["France", "Italy", "Greece", "Spain"],
      correctIndex: 1
    },
    {
      question: "How many legs does a spider have?",
      options: ["6", "8", "10", "12"],
      correctIndex: 1
    },
    {
      question: "What is the largest ocean on Earth?",
      options: ["Atlantic", "Indian", "Arctic", "Pacific"],
      correctIndex: 3
    }
  ];

  const shuffled = shuffleArray(allQuestions);
  return shuffled.slice(0, count).map(q => ({
    ...q,
    id: generateId()
  }));
};

module.exports = {
  generateId,
  shuffleArray,
  getQuiplashPrompts,
  getTriviaQuestions
};
