/**
 * Hackbox Production Server
 * Main entry point for cPanel Node.js deployment
 */

const express = require('express');
const path = require('path');
const hackbox = require('./lib/hackbox-server');
const gameReference = require('./lib/gameReference');

// Use environment port (cPanel sets this automatically)
const port = process.env.PORT || 8080;

const app = express();

// Serve static files from the build folder
app.use(express.static(path.join(__dirname, 'build')));

// Handle React routing - serve index.html for all routes
app.get('*', function(req, res) {
  res.sendFile(path.join(__dirname, 'build', 'index.html'));
});

// Initialize Hackbox with Socket.io
hackbox({ app, port }, gameReference);

console.log(`Hackbox server starting on port ${port}...`);
